IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Cliente_xCampo') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Cliente_xCampo
END
GO

CREATE FUNCTION dbo.CF_Cliente_xCampo(@pId_Cliente INT, @pId_Campo INT) 
RETURNS CHAR(42)
AS
BEGIN
DECLARE @Retorno VARCHAR(5000)


SELECT @Retorno = CASE UPPER(LTRIM(RTRIM(TipoDato)))
					WHEN 'STRING'	THEN Valor_String 
					WHEN 'INTEGER'	THEN CAST(Valor_Integer AS VARCHAR(50))
					WHEN 'DECIMAL'	THEN CAST(Valor_Decimal AS VARCHAR(100))
					WHEN 'MEMO'		THEN Valor_Memo 
					WHEN 'DATE'		THEN CONVERT(VARCHAR(8),Valor_DT ,112)
					WHEN 'TIME'		THEN CONVERT(VARCHAR(8),Valor_DT ,114)
					END
					FROM Clientes_XCampos C, xCampos X
					WHERE C.Id_Campo = @pId_Campo
					AND C.Id_Cliente = @pId_Cliente
					AND X.Id_Campo = C.Id_Campo

RETURN ISNULL(@Retorno,'')

END